/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitCommit;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.actions.AbstractGitHandler;
import com.aptana.git.ui.internal.history.GitCompareFileRevisionEditorInput;
import java.util.Collection;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.history.FileRevisionTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;

public class MergeConflictsHandler
extends AbstractGitHandler {
    protected Object doExecute(ExecutionEvent event) throws ExecutionException {
        Collection<IResource> resources = this.getSelectedResources();
        if (resources == null || resources.size() != 1) {
            return null;
        }
        IResource blah = resources.iterator().next();
        if (blah.getType() != 1) {
            return null;
        }
        GitRepository repo = MergeConflictsHandler.getGitRepositoryManager().getAttached(blah.getProject());
        if (repo == null) {
            return null;
        }
        IPath name = repo.getChangedFileForResource(blah).getRelativePath();
        IFile file = (IFile)blah;
        try {
            IPath copyPath = file.getFullPath().addFileExtension("conflict");
            IFile copy = ResourcesPlugin.getWorkspace().getRoot().getFile(copyPath);
            if (!copy.exists()) {
                file.copy(copyPath, true, (IProgressMonitor)new NullProgressMonitor());
                IFileRevision baseFile = GitPlugin.revisionForCommit((GitCommit)new GitCommit(repo, ":2"), (IPath)name);
                IStorage storage = baseFile.getStorage((IProgressMonitor)new NullProgressMonitor());
                file.setContents(storage.getContents(), true, true, (IProgressMonitor)new NullProgressMonitor());
                file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            return null;
        }
        ITypedElement base = SaveableCompareEditorInput.createFileElement((IFile)file);
        IFileRevision nextFile = GitPlugin.revisionForCommit((GitCommit)new GitCommit(repo, ":3"), (IPath)name);
        FileRevisionTypedElement next = new FileRevisionTypedElement(nextFile);
        GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, (ITypedElement)next, null);
        CompareUI.openCompareEditor((CompareEditorInput)in);
        return null;
    }

    protected boolean calculateEnabled() {
        Collection<IResource> resources = this.getSelectedResources();
        if (resources == null || resources.size() != 1) {
            return false;
        }
        IResource blah = resources.iterator().next();
        if (blah == null || blah.getType() != 1) {
            return false;
        }
        GitRepository repo = MergeConflictsHandler.getGitRepositoryManager().getAttached(blah.getProject());
        if (repo == null) {
            return false;
        }
        ChangedFile file = repo.getChangedFileForResource(blah);
        if (file == null) {
            return false;
        }
        return file.hasUnmergedChanges();
    }
}

